% File name:  test_rmofn.m
% Example analysis of a randomized sliding M-of-N design
N=5;        % Fixed size of sliding M-of-N test
p0=1e-3;    % Bernoulli success probability under H0
p1=0.5;     % Bernoulli success probability under H1
log10F=10;  % log10(average time between false alarms)

[M0,e]=rmofn_design(p0,N,log10F)
% Results:  M0=3, e=0.0393
D0=mofn_asn_naus_mod(p1,[M0 M0+1],N)*[1-e;e]
% Results:  D0=7.5285
[Mopt,Nopt,eopt,Dopt]=rmofn_optimize(p0,p1,log10F)
% Results:  Mopt=3, Nopt=7, eopt=0.1981, Dopt=6.9969