function [Mopt,Nopt,eopt,Dopt]=rmofn_optimize(p0,p1,log10F)
% [Mopt,Nopt,eopt,Dopt]=rmofn_optimize(p0,p1,log10F)
%    Optimal design of a randomized sliding M-of-N detector achieving a specified
%    average time between false alarms for fixed Bernoulli probabilities
% Input parameters: [all are scalar]
%    (p0,p1) = Bernoulli probabilities under noise-only and signal-present hypotheses
%    log10F = log10(average number of samples between false alarms) = log10(1/FAR)
% Output paremeters:
%    (Mopt,Nopt,eopt) = design parameters of the optimized randomized sliding M-of-N detector
%    Dopt = average number of samples before detection
%

% Find the smallest M that will satisfy the FAR spec
M0=floor(log10F/-log10(p0));
while mofn_asn_asy(p0,M0+1,M0+1,1)<log10F, M0=M0+1; end;
% Increase M until find global optimum
Qstop=0; Dopt=inf; 
while ~Qstop,
  % Optimize test for this M
  [N0,N1]=mofn_bound_N(M0,p0,log10F);
  N0=max(N0,M0+1); 
  % Loop through these until find minimum over N
  Dtmp=inf;
  for n=N0:N1,
    % Tune randomized sliding M-of-N test to achieve FAR specification
    log10F01=mofn_asn_asy(p0,M0+[0 1],n,1);
    e=(10^(log10F-log10F01(1))-1)./((10^diff(log10F01))-1);
    Dmn=mofn_asn_naus_mod(p1,M0+[0 1],n)*[1-e;e];
    if Dmn>Dtmp, % Stop searching for this M0 if D is now increasing
      break; 
    else  % Otherwise update and continue
      Dtmp=Dmn; etmp=e; Ntmp=n;      
    end;
  end;
  % Test for minimum over M0
  if Dtmp>Dopt, % Stop if D for this M0 is larger
    Qstop=1;
  else  % Otherwise set these to the minimum and continue
    Mopt=M0; Nopt=Ntmp; eopt=etmp; Dopt=Dtmp;
    M0=M0+1; % Increment M0 until global minimum is found
  end;
end;