function [M0,e]=rmofn_design(p0,N,log10F)
% [M0,e]=rmofn_design(p0,N,log10F)
%    Designs a randomized sliding M-of-N detector to achieve a desired average 
%    time between false alarms
% Parameters:
%    p0 = Bernoulli success probability when only noise is present (e.g., Pf)
%    N = size of test
%    log10F = log10(F) where F = average time between false alarms [units: samples]
%
logFfun=@(M,N,p0) log10(exp(1))*(-M.*log(p0)-(N-M+1).*log(1-p0)+gammaln(M)+gammaln(N-M+1)-gammaln(N));
M0=floor(log10F/-log10(p0)); % Initialize M0 at lower bound
while logFfun(M0+1,N,p0)<log10F, M0=M0+1; end; % Increase to bound F
% Find probability detection is delayed (i.e., prob. M=M0+1)
logF01=logFfun([M0 M0+1],N,p0);
e=(10^(log10F-logF01(1))-1)./((10^diff(logF01))-1);