function [N0,N1]=mofn_bound_N(M0,p0,log10F)
% [N0,N1]=mofn_bound_N(M0,p0,log10F)
%    Bounds on N in a randomized sliding M-of-N detector for achieving a 
%    false alarm rate (FAR) specification given M0 and p0
% Input parameters: [all are scalar]
%    M0 = largest value of M in a sliding M-of-N detector not achieving FAR specification
%    p0 = Bernoulli probability under noise-only hypotheses  
%    log10F = log10(average number of samples between false alarms) = log10(1/FAR)
% Output paremeters:
%    [N0,N1] = min and max values of N achieving or exceeding FAR specification
%
N0=M0; % Increase N0 until below the FAR spec for this value of M
while mofn_asn_asy(p0,M0,N0,1)>log10F,
  N0=N0+1;
end;
% Now increase N0 using M0+1 until no longer meet spec
N1=N0;
while mofn_asn_asy(p0,M0+1,N1+1,1)>log10F,
  N1=N1+1;
end;
