function T=mofn_asn_naus_mod(p,M,N)
% T=mofn_asn_naus_mod(p,M,N)
%     Average sample number for a sliding M-of-N process using Naus' 
%     approximation adjusted to allow stopping after M observations.
% Parameters:  [mix of scalar and common-size matrix/vector]
%   p = Bernoulli probability of success 
%   M = number of successes required for stopping
%   N = window over which successes are counted
%
[p,M,N,T]=input_par_std(p,M,N,nan); Ni=numel(p);
for i=1:Ni,
  if M(i)>1,
    T(i)=mofn_stats_scan_fcn(M(i),N(i),p(i));
  else
    T(i)=1/p(i);
  end;
end;
%-----------------
function [Tout,cg,qg]=mofn_stats_scan_fcn(m,n,p)
fb=binopdf(m,n,p); Fbm1=binocdf(m-1,n,p);
Fbm2=binocdf(m-2,n,p); Fbm3=binocdf(m-3,n,p);
Fbm3n1=binocdf(m-3,n-1,p); Fbm4n1=binocdf(m-4,n-1,p);
Fbm5n2=binocdf(m-5,n-2,p);
Q2=Fbm1.^2-(m-1).*fb.*Fbm2+n.*p.*fb.*Fbm3n1;
A1=2*fb.*Fbm1.*((m-1).*Fbm2-n.*p.*Fbm3n1);
A2=0.5*(fb.^2).*((m-1).*(m-2).*Fbm3-2*(m-2).*n.*p.*Fbm4n1+n.*(n-1).*(p.^2).*Fbm5n2);
r=1:(m-1);
A3=sum(binopdf(2*m-r,n,p).*(binocdf(r-1,n,p).^2));
r=2:(m-1);
A4=sum(binopdf(2*m-r,n,p).*binopdf(r,n,p).*((r-1).*binocdf(r-2,n,p)-n.*p.*binocdf(r-3,n-1,p)));
Q3=Fbm1.^3-A1+A2+A3-A4;
qg=(Q3/Q2)^(1/n); cg=Fbm1; j=(1:n)';
Tout=cg*(n+1/(1-qg))+p*sum(j.*binopdf(m-1,j-1,p));

