function F=mofn_asn_asy(p0,M,N,qLog10)
% F=mofn_asn_naus(p0,M,N,qLog10)
%     Average sample number for a sliding M-of-N process using a small-p0 approximation
%     useful for evaluating the average time between false alarms.
% Parameters:  [mix of scalar and common-size matrix/vector]
%   p0 = Bernoulli probability of success (p0<<1)
%   M = number of successes required for stopping
%   N = window over which successes are counted
%   qLog10 = 1 to return log10(F)
%
if nargin<4, qLog10=0; end;
F=-M.*log(p0)-(N-M+1).*log(1-p0)+gammaln(M)+gammaln(N-M+1)-gammaln(N);
if qLog10,
  F=F*log10(exp(1));
else
  F=exp(F);
end;
