function varargout=input_par_std(varargin)
% [x1,x2,x3,...] = input_par_std(x1,x2,x3,...)
%   Finds the maximum dimension of the input variables (up to 2-D) and
%   fills scalar and vector inputs to be that size 2-D array in the output.
%
nrc=[cellfun('size',varargin,1)' cellfun('size',varargin,2)'];
varargout=cell(1,nargout);
for i=1:nargout, varargout{i}=repmat(varargin{i},max(nrc)-nrc(i,:)+1); end